﻿using System.Collections.Generic;

public class FinanceCompany : IBroker
{
    Dictionary<string, decimal> m_stocks 
        = new Dictionary<string, decimal>();

    decimal pricePerTrade;

    public FinanceCompany()
        : this(10.50m)
    {
    }

    public FinanceCompany(decimal price)
    {
        pricePerTrade = price;
    }

    public string GetRating(string stock)
    {
        return "kupuj";
    }

    public decimal PricePerTrade
    {
        get
        {
            return pricePerTrade;
        }
        set
        {
            pricePerTrade = value;
            PriceChange("Broker finansowy", value);
        }
    }

    public decimal this[string StockName]
    {
        get
        {
            return m_stocks[StockName];
        }
        set
        {
            m_stocks.Add(StockName, value);
        }
    }

    public event ChangeRegistrar PriceChange;
}
